unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Microsoft.DirectX,Microsoft.DirectX.AudioVideoPlayback;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    vid: Video;
  public
    constructor Create;
  private
    procedure UruchomVideo;
    procedure KoniecVideo(sender: System.Object; e: System.EventArgs);
    procedure Zamkniecie(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 266);
  Self.Name := 'TWinForm';
  Self.Text := 'DirectX.NET Przykad Video';
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  UruchomVideo;
end;
procedure TWinForm.UruchomVideo;
begin
  vid:= Video.FromFile('GLOBE.AVI');
  vid.Owner:= Self;
  vid.Size:= Self.Size;

  Include(vid.Ending,  Self.KoniecVideo);
  Include(Self.Closing,Self.Zamkniecie);
  vid.Play();
end;

procedure TWinForm.KoniecVideo(sender: System.Object; e: System.EventArgs);
var ukrytyBox: PictureBox;
    aud: Audio;
begin
  if(vid <> nil) then
  begin
    //Zastp obraz ukrytym box'em, aby nie wywietla
    //"zamroonej" klatki
    ukrytyBox:=PictureBox.Create;
    ukrytyBox.Visible:= false;
    vid.Owner:= ukrytyBox;
  end;
end;

//Zwolnij zasoby w trakcie zamykania aplikacji
procedure TWinForm.Zamkniecie(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
var aud: Audio;
begin
  if(vid <> nil) then
  begin
    if(vid.Playing) then
    begin
      vid.Stop();
    end;
    aud := vid.Audio;
    aud.Dispose();
    vid.Dispose();
  end;
end;

end.
